package com.hero.objects.powers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Possession extends Power {

	private static String xmlID = "POSSESSION";

	public Possession(Element root) {
		super(root, Possession.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		String bonus = "";
		for (Adder ad : getAssignedAdders()) {
			if (ad.isRequired()) {
				if (bonus.trim().length() > 0) {
					bonus += "; ";
				}
				if (ad.getXMLID().equals("MINDCONTROLEFFECT")) {
					bonus += "Mind Control Effect Roll "+(40+ad.getLevels());
				} else if (ad.getXMLID().equals("TELEPATHYEFFECT")) {
					bonus += "Telepathy Effect Roll "+(30+ad.getLevels());
				} else {
					bonus += ad.getAlias().trim();
				}
				ad.setDisplayInString(false);
			}
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}
		if (bonus.trim().length() > 0) {
			ret += " (" + bonus;
		}
		if (getSelectedOption() != null) {
			if (bonus.trim().length() == 0)
				ret += " (";
			else
				ret += "; ";
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			if (bonus.trim().length() == 0)
				ret += ")";
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				if (bonus.trim().length() == 0)
					ret += " (";
				else
					ret += "; ";
				ret += adderString;
				if (bonus.trim().length() == 0)
					ret += ")";
			}
		}
		if (bonus.trim().length() > 0) {
			ret += ")";
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}
}